class XCrade_ArmorBoost extends Armor2;

event float BotDesireability(Pawn Bot)
{
	return (0); 
}

function bool HandlePickupQuery( inventory Item )
{
	local inventory S;

	if ( Pawn(Owner).IsA('Bot'))
		return false;

	if ( item.class == class ) 
	{
		S = Pawn(Owner).FindInventoryType(class'UT_Shieldbelt');	
		if (  S==None )
		{
			if ( Charge<Item.Charge )	
				Charge = Item.Charge;
		}
		else
			Charge = Clamp(S.Default.Charge - S.Charge, Charge, Item.Charge );
		if (Level.Game.LocalLog != None)
			Level.Game.LocalLog.LogPickup(Item, Pawn(Owner));
		if (Level.Game.WorldLog != None)
			Level.Game.WorldLog.LogPickup(Item, Pawn(Owner));
		if ( PickupMessageClass == None )
			Pawn(Owner).ClientMessage(PickupMessage, 'Pickup');
		else
			Pawn(Owner).ReceiveLocalizedMessage( PickupMessageClass, 0, None, None, Self.Class );
		Item.PlaySound (PickupSound,,2.0);
		Item.SetReSpawn();
		return true;				
	}
	if ( Inventory == None )
		return false;

	return Inventory.HandlePickupQuery(Item);
}

function inventory SpawnCopy( pawn Other )
{
	local inventory Copy, S;

	Copy = Super.SpawnCopy(Other);
	S = Other.FindInventoryType(class'UT_Shieldbelt');	
	if ( S != None )
	{
		Copy.Charge = Min(Copy.Charge, S.Default.Charge - S.Charge);
		if ( Copy.Charge <= 0 )
		{ 
			S.Charge -= 1;
			Copy.Charge = 1;
		}
	}
	return Copy;
}

defaultproperties
{
     PickupMessage="Woot! you got the Armor Boost!"
     ItemName="XCrade"
     RespawnTime=0.000000
     PickupViewMesh=Mesh'MHXv3.XCrade'
     Charge=1000
     PickupSound=Sound'Botpack.CTF.CaptureSound'
     Mesh=Mesh'MHXv3.XCrade'
     bCollideWhenPlacing=True
     MultiSkins(0)=Texture'MHXv3.Crades.crade2'
     CollisionRadius=24.000000
     CollisionHeight=24.000000
     bCollideWorld=True
     bBlockActors=True
     bBlockPlayers=True
}
